class TDM_Mutator expands Mutator config(MOS_HASM);

var config string 	TDMGameName,
			TDMLeftMessage,
			TDMEnteredMessage;
var config int		IdentifyRange,
			IdentifyZoomX;
var config string	IntroSound,
			LogoTexture;
var config int		LogoDrawTime;
var config string	RedTeamName,
			BlueTeamName,
			GreenTeamName,
			GoldTeamName,
			RedTeamIcon,
			BlueTeamIcon,
			GreenTeamIcon,
			GoldTeamIcon;

function PreBeginPlay ()
{
	Super.PreBeginPlay();
	SaveConfig();

	Level.Game.ScoreBoardType = Class'TDM_SB';
	Level.Game.HUDType = Class'TDM_HUD';
	Level.Game.GameName = TDMGameName;
	Level.Game.LeftMessage = TDMLeftMessage;
	Level.Game.EnteredMessage = TDMEnteredMessage;

	AddMutator(Level.Spawn(class'TDM_StatsMutator'));
	AddMutator(Level.Spawn(class'IP2Country'));

	SetTimer(1.0,True);
}

function bool AlwaysKeep(Actor Other) 
{	
	if (Other.IsA('PlayerPawn'))
        	{
		PlayerPawn(Other).PlayerReplicationInfoClass = class'PRI';
		return true;
		}
	if (NextMutator != None)
		return (NextMutator.AlwaysKeep(Other));	
	return false;
}

function Timer()
{
local Pawn P;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if ( P.IsA('PlayerPawn') )
			{
			PRI(PlayerPawn(P).PlayerReplicationInfo).IdentifyRange = IdentifyRange;
			PRI(PlayerPawn(P).PlayerReplicationInfo).IdentifyZoomX = IdentifyZoomX;
			PRI(PlayerPawn(P).PlayerReplicationInfo).LogoTexture = LogoTexture;
			PRI(PlayerPawn(P).PlayerReplicationInfo).LogoPause = LogoDrawTime;
			PRI(PlayerPawn(P).PlayerReplicationInfo).IntroSound = IntroSound;
			PRI(PlayerPawn(P).PlayerReplicationInfo).RedTeamName = RedTeamName;
			PRI(PlayerPawn(P).PlayerReplicationInfo).BlueTeamName = BlueTeamName;
			PRI(PlayerPawn(P).PlayerReplicationInfo).GreenTeamName = GreenTeamName;
			PRI(PlayerPawn(P).PlayerReplicationInfo).GoldTeamName = GoldTeamName;
			PRI(PlayerPawn(P).PlayerReplicationInfo).RedIcon = RedTeamIcon;
			PRI(PlayerPawn(P).PlayerReplicationInfo).BlueIcon = BlueTeamIcon;
			PRI(PlayerPawn(P).PlayerReplicationInfo).GreenIcon = GreenTeamIcon;
			PRI(PlayerPawn(P).PlayerReplicationInfo).GoldIcon = GoldTeamIcon;
			}
		}
}

defaultproperties
{
TDMGameName="-MOS- Team DeathMatch"
TDMLeftMessage=" is a quitter!!!"
TDMEnteredMessage=" joined the action!"
IdentifyRange=10000
IdentifyZoomX=1
LogoTexture="MOS_HASM_v1.MOSlogo"
LogoDrawTime=5
IntroSound="MOS_HASM_v1.THX"
RedTeamName="[Red Team]"
BlueTeamName="[Blue Team]"
GreenTeamName="[Green Team]"
GoldTeamName="[Gold Team]"
RedTeamIcon="MOS_HASM_v1.RedIcon"
BlueTeamIcon="MOS_HASM_v1.BlueIcon"
GreenTeamIcon="MOS_HASM_v1.GreenIcon"
GoldTeamIcon="MOS_HASM_v1.GoldIcon"
}





